//////////////////////////////////////////////////////
//	File:	"IGameState.h"
//
//	Author:	David Brown (DB)
//
//	Purpose: To define all the functions states will
//			 have available.
/////////////////////////////////////////////////////

#pragma once

#include "Debug.h"
#include "CSGD_Direct3D.h"

class IGameState
{
public:
	virtual ~IGameState(void) = 0 {}

	virtual void Enter(void) = 0;

	virtual bool Input(float fElapsedTime) = 0;
	virtual void Update(float fElapsedTime) = 0;
	virtual void Render(void) = 0;
	
	virtual void Exit(void) = 0;
};